/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SWTFXUtils {
    private static int blitSrc;
    private static boolean blitSrcCache;
    private static int alphaOpaque;
    private static boolean alphaOpaqueCache;
    private static int msbFirst;
    private static boolean msbFirstCache;
    private static Method blitDirect;
    private static Method blitPalette;
    private static Method getByteOrderMethod;

    private SWTFXUtils() {
    }

    public static WritableImage toFXImage(ImageData imageData, WritableImage image) {
        byte[] data = SWTFXUtils.convertImage(imageData);
        if (data == null) {
            return null;
        }
        int width = imageData.width;
        int height = imageData.height;
        if (image != null) {
            int iw = (int)image.getWidth();
            int ih = (int)image.getHeight();
            if (iw < width || ih < height) {
                image = null;
            } else if (width < iw || height < ih) {
                int[] empty = new int[iw];
                PixelWriter pw = image.getPixelWriter();
                WritablePixelFormat pf = PixelFormat.getIntArgbPreInstance();
                if (width < iw) {
                    pw.setPixels(width, 0, iw - width, height, (PixelFormat)pf, empty, 0, 0);
                }
                if (height < ih) {
                    pw.setPixels(0, height, iw, ih - height, (PixelFormat)pf, empty, 0, 0);
                }
            }
        }
        if (image == null) {
            image = new WritableImage(width, height);
        }
        PixelWriter pw = image.getPixelWriter();
        int scan = width * 4;
        WritablePixelFormat pf = PixelFormat.getByteBgraInstance();
        pw.setPixels(0, 0, width, height, (PixelFormat)pf, data, 0, scan);
        return image;
    }

    public static ImageData fromFXImage(Image image, ImageData imageData) {
        PixelReader pr = image.getPixelReader();
        if (pr == null) {
            return null;
        }
        int width = (int)image.getWidth();
        int height = (int)image.getHeight();
        int bpr = width * 4;
        int dataSize = bpr * height;
        byte[] buffer = new byte[dataSize];
        WritablePixelFormat pf = PixelFormat.getByteBgraInstance();
        pr.getPixels(0, 0, width, height, pf, buffer, 0, bpr);
        byte[] alphaData = new byte[width * height];
        int offset = 0;
        int alphaOffset = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                byte alpha = buffer[offset + 3];
                buffer[offset + 3] = 0;
                alphaData[alphaOffset++] = alpha;
                ++x;
                offset += 4;
            }
        }
        PaletteData palette = new PaletteData(65280, 0xFF0000, -16777216);
        imageData = new ImageData(width, height, 32, palette, 4, buffer);
        imageData.alphaData = alphaData;
        return imageData;
    }

    private static int BLIT_SRC() throws Exception {
        if (!blitSrcCache) {
            blitSrc = SWTFXUtils.readValue("BLIT_SRC");
            blitSrcCache = true;
        }
        return blitSrc;
    }

    private static int ALPHA_OPAQUE() throws Exception {
        if (!alphaOpaqueCache) {
            alphaOpaque = SWTFXUtils.readValue("ALPHA_OPAQUE");
            alphaOpaqueCache = true;
        }
        return alphaOpaque;
    }

    private static int MSB_FIRST() throws Exception {
        if (!msbFirstCache) {
            msbFirst = SWTFXUtils.readValue("MSB_FIRST");
            msbFirstCache = true;
        }
        return msbFirst;
    }

    private static int readValue(String name) throws Exception {
        Class<ImageData> clazz = ImageData.class;
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field.getInt(clazz);
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... argClasses) throws Exception {
        Method method = clazz.getDeclaredMethod(name, argClasses);
        method.setAccessible(true);
        return method;
    }

    private static void blit(int op, byte[] srcData, int srcDepth, int srcStride, int srcOrder, int srcX, int srcY, int srcWidth, int srcHeight, int srcRedMask, int srcGreenMask, int srcBlueMask, int alphaMode, byte[] alphaData, int alphaStride, int alphaX, int alphaY, byte[] destData, int destDepth, int destStride, int destOrder, int destX, int destY, int destWidth, int destHeight, int destRedMask, int destGreenMask, int destBlueMask, boolean flipX, boolean flipY) throws Exception {
        Class<ImageData> clazz = ImageData.class;
        if (blitDirect == null) {
            Class<Integer> I = Integer.TYPE;
            Class<Boolean> B = Boolean.TYPE;
            Class<byte[]> BA = byte[].class;
            Class[] argClasses = new Class[]{I, BA, I, I, I, I, I, I, I, I, I, I, I, BA, I, I, I, BA, I, I, I, I, I, I, I, I, I, I, B, B};
            blitDirect = SWTFXUtils.getMethod(clazz, "blit", argClasses);
        }
        if (blitDirect != null) {
            blitDirect.invoke(clazz, op, srcData, srcDepth, srcStride, srcOrder, srcX, srcY, srcWidth, srcHeight, srcRedMask, srcGreenMask, srcBlueMask, alphaMode, alphaData, alphaStride, alphaX, alphaY, destData, destDepth, destStride, destOrder, destX, destY, destWidth, destHeight, destRedMask, destGreenMask, destBlueMask, flipX, flipY);
        }
    }

    private static void blit(int op, byte[] srcData, int srcDepth, int srcStride, int srcOrder, int srcX, int srcY, int srcWidth, int srcHeight, byte[] srcReds, byte[] srcGreens, byte[] srcBlues, int alphaMode, byte[] alphaData, int alphaStride, int alphaX, int alphaY, byte[] destData, int destDepth, int destStride, int destOrder, int destX, int destY, int destWidth, int destHeight, int destRedMask, int destGreenMask, int destBlueMask, boolean flipX, boolean flipY) throws Exception {
        Class<ImageData> clazz = ImageData.class;
        if (blitPalette == null) {
            Class<Integer> I = Integer.TYPE;
            Class<Boolean> B = Boolean.TYPE;
            Class<byte[]> BA = byte[].class;
            Class[] argClasses = new Class[]{I, BA, I, I, I, I, I, I, I, BA, BA, BA, I, BA, I, I, I, BA, I, I, I, I, I, I, I, I, I, I, B, B};
            blitPalette = SWTFXUtils.getMethod(clazz, "blit", argClasses);
        }
        if (blitPalette != null) {
            blitPalette.invoke(clazz, op, srcData, srcDepth, srcStride, srcOrder, srcX, srcY, srcWidth, srcHeight, srcReds, srcGreens, srcBlues, alphaMode, alphaData, alphaStride, alphaX, alphaY, destData, destDepth, destStride, destOrder, destX, destY, destWidth, destHeight, destRedMask, destGreenMask, destBlueMask, flipX, flipY);
        }
    }

    private static int getByteOrder(ImageData image) throws Exception {
        Class<ImageData> clazz = ImageData.class;
        if (getByteOrderMethod != null) {
            getByteOrderMethod = SWTFXUtils.getMethod(clazz, "getByteOrder", new Class[0]);
        }
        if (getByteOrderMethod != null) {
            return (Integer)getByteOrderMethod.invoke((Object)image, new Object[0]);
        }
        return SWTFXUtils.MSB_FIRST();
    }

    private static byte[] convertImage(ImageData image) {
        byte[] buffer = null;
        try {
            boolean hasAlpha;
            PaletteData palette = image.palette;
            if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
                return null;
            }
            int BLIT_SRC = SWTFXUtils.BLIT_SRC();
            int ALPHA_OPAQUE = SWTFXUtils.ALPHA_OPAQUE();
            int MSB_FIRST = SWTFXUtils.MSB_FIRST();
            int width = image.width;
            int height = image.height;
            int byteOrder = SWTFXUtils.getByteOrder(image);
            int ao = 3;
            int redMask = 65280;
            int greenMask = 0xFF0000;
            int blueMask = -16777216;
            int dataSize = width * height * 4;
            int bpr = width * 4;
            buffer = new byte[dataSize];
            if (palette.isDirect) {
                SWTFXUtils.blit(BLIT_SRC, image.data, image.depth, image.bytesPerLine, byteOrder, 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, ALPHA_OPAQUE, null, 0, 0, 0, buffer, 32, bpr, MSB_FIRST, 0, 0, width, height, redMask, greenMask, blueMask, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                for (int i = 0; i < rgbs.length; ++i) {
                    RGB rgb = rgbs[i];
                    if (rgb == null) continue;
                    srcReds[i] = (byte)rgb.red;
                    srcGreens[i] = (byte)rgb.green;
                    srcBlues[i] = (byte)rgb.blue;
                }
                SWTFXUtils.blit(BLIT_SRC, image.data, image.depth, image.bytesPerLine, byteOrder, 0, 0, width, height, srcReds, srcGreens, srcBlues, ALPHA_OPAQUE, null, 0, 0, 0, buffer, 32, bpr, MSB_FIRST, 0, 0, width, height, redMask, greenMask, blueMask, false, false);
            }
            int transparency = image.getTransparencyType();
            boolean bl = hasAlpha = transparency != 0;
            if (transparency == 2 || image.transparentPixel != -1) {
                ImageData maskImage = image.getTransparencyMask();
                byte[] maskData = maskImage.data;
                int maskBpl = maskImage.bytesPerLine;
                int offset = 0;
                int maskOffset = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        byte m = maskData[maskOffset + (x >> 3)];
                        int v = 1 << 7 - (x & 7);
                        buffer[offset + ao] = (m & v) != 0 ? -1 : 0;
                        offset += 4;
                    }
                    maskOffset += maskBpl;
                }
            } else if (image.alpha != -1) {
                hasAlpha = true;
                int alpha = image.alpha;
                byte a = (byte)alpha;
                for (int offset = 0; offset < buffer.length; offset += 4) {
                    buffer[offset + ao] = a;
                }
            } else if (image.alphaData != null) {
                hasAlpha = true;
                byte[] alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, alphaData, 0, alphaData.length);
                int offset = 0;
                int alphaOffset = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        buffer[offset + ao] = alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                    }
                }
            }
            if (!hasAlpha) {
                for (int offset = 0; offset < buffer.length; offset += 4) {
                    buffer[offset + ao] = -1;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return buffer;
    }
}

